require "prefabutil"

local assets =
{
    Asset("ANIM", "anim/plant.zip"),
	Asset("ATLAS", "images/inventoryimages/plant.xml")
}

local prefabs =
{
    "collapse_small",
}

local function onhammered(inst, worker)
    if inst.components.burnable ~= nil and inst.components.burnable:IsBurning() then
        inst.components.burnable:Extinguish()
    end
    local x, y, z = inst.Transform:GetWorldPosition()
    SpawnPrefab("glass").Transform:SetPosition(x, y, z)
	SpawnPrefab("coherer").Transform:SetPosition(x, y, z)
	
    inst:Remove()
end

local function onhit(inst, worker)
	inst.AnimState:PlayAnimation("hit")
	inst.AnimState:PushAnimation("idle", true)
end
local function onactivate(inst)
    inst._activecount = inst._activecount + 1
    --if not inst.SoundEmitter:PlayingSound("sound") then
    --    inst.SoundEmitter:PlaySound("dontstarve/common/ancienttable_craft", "sound")
    --end

    inst:DoTaskInTime(1.5, complete_doonact)
end
------提取系统-----------------
local function OnGetItemFromPlayer(inst, giver, item)       
--花瓣=再生基因
    if item.prefab == "petals" 
	then 
	giver.components.inventory:GiveItem( SpawnPrefab("gene_zaisheng"))
    end
--松果=自适应基因
    if item.prefab == "pinecone" 
	then 
	giver.components.inventory:GiveItem( SpawnPrefab("gene_zishiying"))
    end
--食人花种子=骨骼基因+敏捷基因+免疫基因+叶绿素基因
    if item.prefab == "lureplantbulb" 
	then 
	giver.components.inventory:GiveItem( SpawnPrefab("gene_guge"))
	giver.components.inventory:GiveItem( SpawnPrefab("gene_yelvsu"))
	giver.components.inventory:GiveItem( SpawnPrefab("gene_minjie"))
	giver.components.inventory:GiveItem( SpawnPrefab("gene_mianyi"))
    end
--胡萝卜=螺旋基因+抵抗基因+能量基因
    if item.prefab == "carrot" 
	then 
	giver.components.inventory:GiveItem( SpawnPrefab("gene_nengliang"))
	giver.components.inventory:GiveItem( SpawnPrefab("gene_dikang"))
	giver.components.inventory:GiveItem( SpawnPrefab("gene_luoxuan"))
    end
--浆果=水基因+叶绿素基因
    if item.prefab == "berries" 
	then 
	giver.components.inventory:GiveItem( SpawnPrefab("gene_shuisu"))
	giver.components.inventory:GiveItem( SpawnPrefab("gene_yelvsu"))
    end
--红/蓝/绿蘑菇=发光+自适应+毒性/再生/虚空基因
    if item.prefab == "red_cap" 
	then 
	giver.components.inventory:GiveItem( SpawnPrefab("gene_zishiying"))
	giver.components.inventory:GiveItem( SpawnPrefab("gene_faguang"))
	giver.components.inventory:GiveItem( SpawnPrefab("gene_duxing"))
    end
    if item.prefab == "green_cap" 
	then 
	giver.components.inventory:GiveItem( SpawnPrefab("gene_zishiying"))
	giver.components.inventory:GiveItem( SpawnPrefab("gene_faguang"))
	giver.components.inventory:GiveItem( SpawnPrefab("gene_xukong"))
    end
    if item.prefab == "blue_cap" 
	then 
	giver.components.inventory:GiveItem( SpawnPrefab("gene_zishiying"))
	giver.components.inventory:GiveItem( SpawnPrefab("gene_faguang"))
	giver.components.inventory:GiveItem( SpawnPrefab("gene_zaisheng"))
    end
--
	end
local function onbuilt(inst)
    inst.SoundEmitter:PlaySound("dontstarve/common/sign_craft")
end
local function OnRefuseItem(inst, giver, item)
    inst.SoundEmitter:PlaySound("dontstarve/pig/PigKingReject")
    inst.AnimState:PlayAnimation("hit")
end
local function fn()
    local inst = CreateEntity()
    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddSoundEmitter()
    inst.entity:AddNetwork()
    MakeObstaclePhysics(inst, .2)
	inst.entity:AddDynamicShadow()
	inst.DynamicShadow:SetSize( 2.5, 2.5)
    inst.AnimState:SetBank("plant")
    inst.AnimState:SetBuild("plant")
    inst.AnimState:PlayAnimation("idle",true)
    MakeSnowCoveredPristine(inst)
    inst:AddTag("structure")
    inst:AddTag("sign")
    inst.entity:SetPristine()
    if not TheWorld.ismastersim then
        return inst
    end
	--分解
     inst:AddComponent("trader")
	 inst.components.trader:SetAcceptTest(function(inst,item)
	 if item.petals == "pinecone" or item.prefab == "petals" or item.prefab == "lureplantbulb" or item.prefab == "carrot"  or item.prefab == "berries"  or item.prefab == "red_cap" or item.prefab == "blue_cap" or item.prefab == "green_cap" or item.prefab == "seeds" 
		 then
	 return true
	 end
	 return false
	 end)
	 inst.components.trader.onaccept = OnGetItemFromPlayer
	------------------------------
	inst:AddComponent("prototyper")
    inst.components.prototyper.onactivate = onactivate
	inst.components.prototyper.trees = TUNING.PROTOTYPER_TREES.TOU_FARM_TWO
	inst:AddComponent("workable")
    inst.components.workable:SetWorkAction(ACTIONS.HAMMER)
    inst.components.workable:SetWorkLeft(5)
    inst.components.workable:SetOnFinishCallback(onhammered)
    inst.components.workable:SetOnWorkCallback(onhit)
    inst:AddComponent("inspectable")
    inst:AddComponent("lootdropper")
	   inst:ListenForEvent("onbuilt", onbuilt)
	   MakeHauntableWork(inst)
    return inst
end
return Prefab("plant", fn, assets, prefabs),
    MakePlacer("plant_placer", "plant", "plant", "idle")